#!/usr/bin/env python3

import os
import sys
import argparse

from pathlib import Path

filedir = Path(os.path.dirname(__file__)).resolve()
sys.path.insert(0, (filedir / 'ext').as_posix())

if hasattr(os, 'add_dll_directory'):
    os.add_dll_directory(filedir / 'ext' / 'lib')

import tachyon

parser = argparse.ArgumentParser()
parser.add_argument('-o', dest='output', default=None)

options = parser.parse_args(sys.argv[1:])

result = tachyon.phaserize('shoot')

if options.output:
    with open(options.output, 'w') as f:
        f.write('success')

if not isinstance(result, int):
    raise SystemExit('Returned result not an integer.')

if result != 1:
    raise SystemExit(f'Returned result {result} is not 1.')
